import { Dimensions, StyleSheet } from "react-native";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";
const { width, height } = Dimensions.get("window");

export const addNewAddressStyle = StyleSheet.create({
    container: {
        paddingHorizontal: dpr(20),
        backgroundColor: "#fff",
        minHeight: height,
        paddingBottom: dpr(26),
    },
    default: {
        marginTop: dpr(18),
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 4,
        paddingHorizontal: dpr(12),
        flexDirection: "row",
        alignItems: "center",
        height: dpr(42),
    },
    defaultIcon: {
        height: dpr(16),
        width: dpr(16),
    },
    defaultText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        marginLeft: dpr(10),
    },
    deleteAddress: {
        marginTop: dpr(18),
        width: dpr(174),
        height: dpr(42),
        backgroundColor: "#2C2C2C",
    },
    deleteAddressBtnCont: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
    },
    deleteAddressBtn: {
        paddingTop: 10,
    },
    deleteAddressBtnText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        lineHeight: dpr(18),
        color: "#FFFFFF",
        marginLeft: dpr(6),
        marginTop: dpr(4),
    },
    dropdown1BtnStyle: (name) => ({
        width: (width - dpr(55)) / 2,
        height: dpr(42),
        borderColor: name ? "#E43147" : "#DFDFDF",
    }),
    dropdown1BtnTextStyle: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(15),
        color: "#898989",
    },
    saveAddressCont: {
        width: (width - dpr(50)) / 2,
        height: dpr(45),
        backgroundColor: "#FCCA19",
        justifyContent: "center",
        alignItems: "center",
        borderRadius: dpr(6),
    },
    saveAddressBtn: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        lineHeight: dpr(21),
        color: "#2C2C2C",
    },
});
